/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/

/**
 * \file    camera.c
 *
 * \brief   configuring AR0331 sensor via I2C
 *
 * This file contains the generic routines for configuring the AR0331 sensor
 * on the DM388 on a specific bus instance(i2c2).
 *
 * \author  Akhil kumar
 *
 * \version 01,15 sept 2016
 */

/*
 *====================
 * Includes
 *====================
 */
//#include "DM388_types.h"
//#include "DM388_EVM.h"
//#include "DM388_i2c.h"
//#include "gpio.h"
//#include "stdio.h"
#include "stdlib.h"
#include "string.h"
//#include "camera.h"
#include "platform.h"


//TEST_STATUS ar0331_readRegister(UINT16 reg_addr,UINT16 reg_val);

UINT16 regValue[100];
UINT16 regAddr[100];

#define PLL_MULTIPLIER (0x4A)
#define INPUT_CLK    24                                    // EXTCLK
#define PLL_P2       6
#define PLL_M        (74)                                 // pll_multiplier
#define PLL_pre_div  4                                     // pre_pll_clk_div
#define OUT_CLK ((INPUT_CLK * PLL_M) / (PLL_pre_div * PLL_P1 * PLL_P2) )//74MHz (30fps)
#define OP_SYS_CLK_DIV	(1)
#define PLL_P1       1   //vt_sys_clk_div

#define I2C_BUS_NUM  2
#define I2C_WRITE_DELAY (0x1FFF)
#define SENSOR_I2C_WRITE_DELAY (0x2FFF)

//#define I2C_READ

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  Testing Function                                                        *
 *                                                                          *
 * ------------------------------------------------------------------------ */
#if 0
void TEST_execute( STATUS ( *funchandle )( void), char *testname, INT16 testid )
{
    STATUS status = SUCCESS;

    /* Display test ID */
    platform_write( "%02d  Testing %s...\n", testid, testname );

    /* Call test function */
    if (testid)
        status = funchandle();
    else
        status = funchandle();

    /* Check for test fail */
    if ( status != 0 )
    {
        /* Print error message */
        platform_write( " camera sensor configuration failed\r\n");
    }
    else
    {
        /* Print error message */
        platform_write( "camera sensor configuration successed\n" );
    }
}
#endif
/** **************************************************************************
 * \n \brief Routine to reset aptina AR0031 Sensor by gpio pin toggling
 *
 * This routine reset the AR0031 Sensor
 *
 *
 * \return
 * \n      return SUCCESS for success
 * \n      return FAILED for error
 ******************************************************************************/

void camera_reset_toggle(void)
{
	GPIO2_SYSCONFIG = 0x0000002; /* Software Reset */
	DM388_wait(0x90000);
	GPIO2_SYSCONFIG = 0x100; /* no-idle */

	GPIO2_OE &= ~(1 <<  18);
	GPIO2_SETDATAOUT = (1 <<  18);
	DM388_wait( 0x3FFFF );
	//GPIO2_CLEARDATAOUT = (1 <<  18);
	//DM388_wait( 0x3FFFF );
}

/** **************************************************************************
 * \n \brief Routine to read aptina AR0031 Sensor registers via i2c-2
 *
 * This routine read the AR0031 Sensor Register data
 *
 *
 * \return
 * \n      return SUCCESS for success
 * \n      return FAILED for error
 ******************************************************************************/

TEST_STATUS ar0331_readRegister(UINT16 reg_addr,UINT16 reg_val)
{
	INT16 u32RetVal=SUCCESS;
	UINT8 buffer[5];
	UINT8 rx_buf[2];
	UINT8 u8DataWritten=0;
	UINT8 u8DataRead=0;
	INT32 devAddr = 0x10;


	buffer[0] = (reg_addr >> 0x8);
	buffer[1] = (reg_addr & 0xFF);

	u32RetVal=DM388I2cWitecamera(I2C_BUS_NUM,devAddr,buffer,2,&u8DataWritten);
	if(u32RetVal!=SUCCESS)
	{
		u32RetVal=FAILED;
		return u32RetVal;
	}
	DM388_wait(SENSOR_I2C_WRITE_DELAY);

	u32RetVal=DM388I2cRead(I2C_BUS_NUM,devAddr,rx_buf,2,&u8DataRead);
	if(u32RetVal!=SUCCESS)
	{
		u32RetVal=FAILED;
		return u32RetVal;
	}

	reg_val = (UINT16)((rx_buf[0] << 8) | rx_buf[1]);

	platform_write("value of register 0x%04X is 0x%04X \n",reg_addr,reg_val);

	return u32RetVal;

}
/** **************************************************************************
 * \n \brief Routine to configure aptina AR0031 Sensor registers via i2c-2
 *
 * This routine configure the AR0031 Sensor Register
 *
 *
 * \return
 * \n      return SUCCESS for success
 * \n      return FAILED for error
 ******************************************************************************/

TEST_STATUS ar0331_configuration()
{

		INT16 u32RetVal=SUCCESS;
		int i = 0;
	    UINT8 buffer[5];
	    UINT8  u8DataWritten = 0;
	    int j,k;
	    INT32 devAddr = 0x10;
	    UINT16 reg_val=0;;


    regAddr[i] = 0x302A; regValue[i] = PLL_P2 ;	i++;// VT_PIX_CLK_DIV
	regAddr[i] = 0x301A; regValue[i] = 0x0001; i++;  	// RESET_REGISTER

	regAddr[i] = 0x301A; regValue[i] = 0x0058; i++;  	// RESET_REGISTER
	regAddr[i] = 0x31AC; regValue[i] = 0x0C0C; i++; 		//DATA_FORMAT_BITS = 3084
		//PLL_settings - 4 Lane 12-bit HiSPi

	regAddr[i] = 0x302A; regValue[i] = PLL_P2 ;	i++;// VT_PIX_CLK_DIV
	regAddr[i] = 0x302C; regValue[i] = PLL_P1 ;	i++;// VT_SYS_CLK_DIV
	regAddr[i] = 0x302E; regValue[i] = PLL_pre_div ;	i++;// PRE_PLL_CLK_DIV
	regAddr[i] = 0x3030; regValue[i] = PLL_M ; 	i++;// PLL_MULTIPLIER
	regAddr[i] =0x3036; regValue[i] = 0x000C;  i++;  // OP_PIX_CLK_DIV
	regAddr[i] = 0x3038; regValue[i] = OP_SYS_CLK_DIV; 	i++;// OP_SYS_CLK_DIV
	regAddr[i] =0x3002; regValue[i] = 0x00E4;  i++;  // Y_ADDR_START
	regAddr[i] =0x3004; regValue[i] = 0x0042;  i++;  // X_ADDR_START
	regAddr[i] =0x3006; regValue[i] = 0x0523;  i++;  // Y_ADDR_END
	regAddr[i] = 0x3008; regValue[i] = 0x07c9; i++;  //regAddr[i] = 0x3008; regValue[i] = 0x07C0; i++; 	// X_ADDR_END
	regAddr[i] =0x300A; regValue[i] = 0x0465;  i++;  // FRAME_LENGTH_LINES
	regAddr[i] =0x300C; regValue[i] = 0x044C;  i++;  // LINE_LENGTH_PCK
	regAddr[i] =0x3012; regValue[i] = 0x0438;  i++;  // COARSE_INTEGRATION_TIME
	regAddr[i] =0x30A2; regValue[i] = 0x0001;  i++;  // X_ODD_INC
	regAddr[i] =0x30A6; regValue[i] = 0x0001;  i++;  // Y_ODD_INC


	regAddr[i] =0x3040; regValue[i] = 0x0000;  i++;  // READ_MODE

	regAddr[i] =0x31AE; regValue[i] = 0x0304;  i++;  // SERIAL_FORMAT
	regAddr[i] = 0x31C6; regValue[i] = 0x8400; 	i++; // HISPI_CONTROL_STATUS
	regAddr[i] =0x306E; regValue[i] = 0x9010;  i++;  // DATAPATH_SELECT
	//Analog Settings
	regAddr[i] =0x3180; regValue[i] = 0x8089;  i++;  // DELTA_DK_CONTROL

	regAddr[i] =0x301A; regValue[i] = 0x005C;  i++;  // RESET_REGISTER


	    for (j = 0; j < i; j++)
	    {
	    	buffer[0] = (regAddr[j] >> 0x8);
	    	buffer[1] = (regAddr[j] & 0xFF);

	    	buffer[2]= (regValue[j] >> 0x8);
	    	buffer[3] =(regValue[j]  & 0xFF);


	    	u32RetVal = DM388I2cWitecamera(I2C_BUS_NUM,devAddr,buffer,4,&u8DataWritten);


	    	if(u32RetVal!=SUCCESS)
	    	{
	    		platform_write("i2c write failed for register: 0x%04X \n",regAddr[j]);
	    		u32RetVal= FAILED;
	    	}

	    	if(regAddr[j]==0x301a)
	    		DM388_wait(I2C_WRITE_DELAY);

	    	else
	    		DM388_wait(I2C_WRITE_DELAY);

	    }

	   platform_write(" ar0331_configuration completed\n");

//read all AR0331 Sensor Register
#ifdef I2C_READ

	   for (k = 0; k < j; k++)
	   {
		   ar0331_readRegister(regAddr[k],reg_val);
	   }
#endif
	   return u32RetVal;
}

/** **************************************************************************
 * \n \brief Routine to configure lvds control registers via i2c-2
 *
 * This routine configure the bridge chip(i.e lvds) interfacing between sensor and controller
 *
 *
 * \return
 * \n      return SUCCESS for success
 * \n      return FAILED for error
 ******************************************************************************/

TEST_STATUS lvds_configuration()
{
	UINT8 i;
	UINT8 buffer[4];
	UINT8 u8DataWritten=0;
	INT16 u32RetVal=SUCCESS;
	UINT8 u8DataRead=0;
	UINT8 rx_buf[0x0f];

	UINT16	u8SlaveAddr=0x2d;


	 //read all register from 0x0 to 0xa
#ifdef I2C_READ
	 u32RetVal = DM388I2cRead(I2C_BUS_NUM,u8SlaveAddr,rx_buf,0xb,&u8DataRead);
	 for(i=0;i<11;i++)
	 {
	 platform_write("device ID value is %x at register address %x\n",rx_buf[i],i);

	 }
#endif
	 //i2c write: Register->0x28 and data->0x03
	buffer[0]=0x28;
	buffer[1]=0X03;
	u32RetVal = DM388I2cWitecamera(I2C_BUS_NUM,u8SlaveAddr,buffer,2,&u8DataWritten);
	if(u32RetVal!=SUCCESS)
	{
		platform_write("lvds i2c write failed for register:0x28\n");
		return FAILED;
	}

	DM388_wait(I2C_WRITE_DELAY);

	//i2c write:Register->0x09 and data->0x24
	buffer[0]=0x09;
	buffer[1]=0x24;

   u32RetVal = DM388I2cWitecamera(I2C_BUS_NUM,u8SlaveAddr,buffer,2,&u8DataWritten);

	if(u32RetVal!=SUCCESS)
	{
		platform_write("lvds i2c write failed for register:0x09\n");
		return FAILED;
	}
	DM388_wait(I2C_WRITE_DELAY);

	//read register 0x09
#ifdef I2C_READ

	u32RetVal = DM388I2cWitecamera(I2C_BUS_NUM,u8SlaveAddr,buffer,1,&u8DataWritten);
	DM388_wait(100);
	u32RetVal = DM388I2cRead(I2C_BUS_NUM,u8SlaveAddr,rx_buf,1,&u8DataRead);
	platform_write("value of register 0x9 is %x \n",rx_buf[0]);
#endif

	//i2c write: Register->0x0a and data->0x22
	buffer[0]=0x0A;
	buffer[1]=0x22;

	u32RetVal = DM388I2cWitecamera(I2C_BUS_NUM,u8SlaveAddr,buffer,2,&u8DataWritten);

	if(u32RetVal!=SUCCESS)
	{
		platform_write("lvds i2c write failed for register:0x0a \n");
		return FAILED;
	}
	DM388_wait(I2C_WRITE_DELAY);

	//read register 0x0a
#ifdef I2C_READ

	buffer[0]=0x0A;
	u32RetVal = DM388I2cWitecamera(I2C_BUS_NUM,u8SlaveAddr,buffer,1,&u8DataWritten);
	DM388_wait(100);
	u32RetVal = DM388I2cRead(I2C_BUS_NUM,u8SlaveAddr,rx_buf,1,&u8DataRead);

	platform_write("value of register 0xA is %x \n",rx_buf[0]);
#endif

	platform_write(" lvds configuration completed\n");
return (SUCCESS);
}


TEST_STATUS camera_i2c_configuration(void *testArgs)
{
	INT16 u32RetVal=SUCCESS;
	DM388I2cInit( 2 );

	camera_reset_toggle();

	u32RetVal=lvds_configuration();
	if(u32RetVal!=SUCCESS)
	{
		return FAILED;

	}
	u32RetVal=ar0331_configuration();
	if(u32RetVal!=SUCCESS)
	{
		return FAILED;
	}

return SUCCESS;
}

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  main( )                                                                 *
 *                                                                          *
 * ------------------------------------------------------------------------ */
INT32 camera_test(void *testArgs)
{

	INT16 testStatus;
    platform_write("\n***************************\n\r");
    platform_write(  "         Camera Test       \n\r");
    platform_write(  "***************************\n\r");
    /* Initialize EVM */
	//DM388_Init ();

    platform_write("\nRunning Camera configurations\n");
	testStatus=camera_i2c_configuration(testArgs);

	platform_write("\nCamera Test Completed!!\n");
	platform_write("-----------x----------");
    return testStatus;
}
